/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.launcher;

import com.mojang.authlib.launcher.GenericGameProfile;
import com.mojang.authlib.launcher.GenericProperty;
import com.mojang.authlib.launcher.LauncherAccessor;
import com.mojang.authlib.launcher.LauncherUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class LauncherReflectionAccessor
implements LauncherAccessor {
    private final Class<?> API_HOLDER;
    private final MethodHandle LOG_HELPER_ERROR;
    private final MethodHandle LOG_HELPER_DEBUG;
    private final MethodHandle GET_API_HOLDER;
    private final MethodHandle GET_USER_FEATURE_API;
    private final MethodHandle GET_USER_BY_USERNAME;
    private final MethodHandle GET_USER_BY_UUID;
    private final MethodHandle JOIN_SERVER_BY_USERNAME;
    private final MethodHandle JOIN_SERVER_BY_UUID;
    private final MethodHandle CHECK_SERVER;
    private final MethodHandle GETTER_GET_USERNAME;
    private final MethodHandle GETTER_GET_UUID;
    private final MethodHandle GETTER_GET_ASSETS;
    private final MethodHandle GETTER_GET_PROPERTIES;
    private final MethodHandle GETTER_GET_TEXTURE_URL;
    private final MethodHandle GETTER_GET_TEXTURE_HASH;
    private final MethodHandle GETTER_GET_TEXTURE_METADATA;
    private final MethodHandle GETTER_GET_CHECK_SESSION_ID;
    private final MethodHandle GETTER_GET_CHECK_HARDWARE_ID;
    private final MethodHandle GETTER_GET_CHECK_PROPERTIES;
    private final MethodHandle GETTER_GET_CHECK_USER;

    private static ClassLoader getSystemClassLoader() {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle mh = lookup.findStatic(ClassLoader.class, "getSystemClassLoader", MethodType.methodType(ClassLoader.class));
            return mh.invoke();
        }
        catch (Throwable e) {
            return ClassLoader.getSystemClassLoader();
        }
    }

    public LauncherReflectionAccessor() throws Throwable {
        ClassLoader classloader = LauncherReflectionAccessor.getSystemClassLoader();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Class<?> LOG_HELPER = Class.forName("pro.gravit.utils.helper.LogHelper", false, classloader);
        this.LOG_HELPER_ERROR = lookup.findStatic(LOG_HELPER, "error", MethodType.methodType(Void.TYPE, Throwable.class));
        this.LOG_HELPER_DEBUG = lookup.findStatic(LOG_HELPER, "debug", MethodType.methodType(Void.TYPE, String.class, Object[].class));
        this.API_HOLDER = Class.forName("pro.gravit.launcher.core.api.LauncherAPIHolder", false, classloader);
        Class<?> LAUNCHER_API = Class.forName("pro.gravit.launcher.core.api.LauncherAPI", false, classloader);
        Class<?> USER_FEATURE_API = Class.forName("pro.gravit.launcher.core.api.features.UserFeatureAPI", false, classloader);
        this.GET_API_HOLDER = lookup.findStatic(this.API_HOLDER, "get", MethodType.methodType(LAUNCHER_API));
        this.GET_USER_FEATURE_API = lookup.findVirtual(LAUNCHER_API, "user", MethodType.methodType(USER_FEATURE_API));
        this.GET_USER_BY_USERNAME = lookup.findVirtual(USER_FEATURE_API, "getUserByUsername", MethodType.methodType(CompletableFuture.class, String.class));
        this.GET_USER_BY_UUID = lookup.findVirtual(USER_FEATURE_API, "getUserByUUID", MethodType.methodType(CompletableFuture.class, UUID.class));
        this.JOIN_SERVER_BY_USERNAME = lookup.findVirtual(USER_FEATURE_API, "joinServer", MethodType.methodType(CompletableFuture.class, String.class, String.class, String.class));
        this.JOIN_SERVER_BY_UUID = lookup.findVirtual(USER_FEATURE_API, "joinServer", MethodType.methodType(CompletableFuture.class, UUID.class, String.class, String.class));
        this.CHECK_SERVER = lookup.findVirtual(USER_FEATURE_API, "checkServer", MethodType.methodType(CompletableFuture.class, String.class, String.class, Boolean.TYPE));
        Class<?> USER = Class.forName("pro.gravit.launcher.core.api.model.User", false, classloader);
        this.GETTER_GET_USERNAME = lookup.findVirtual(USER, "getUsername", MethodType.methodType(String.class));
        this.GETTER_GET_UUID = lookup.findVirtual(USER, "getUUID", MethodType.methodType(UUID.class));
        this.GETTER_GET_ASSETS = lookup.findVirtual(USER, "getAssets", MethodType.methodType(Map.class));
        this.GETTER_GET_PROPERTIES = lookup.findVirtual(USER, "getProperties", MethodType.methodType(Map.class));
        Class<?> TEXTURE = Class.forName("pro.gravit.launcher.core.api.model.Texture", false, classloader);
        this.GETTER_GET_TEXTURE_URL = lookup.findVirtual(TEXTURE, "getUrl", MethodType.methodType(String.class));
        this.GETTER_GET_TEXTURE_HASH = lookup.findVirtual(TEXTURE, "getHash", MethodType.methodType(String.class));
        this.GETTER_GET_TEXTURE_METADATA = lookup.findVirtual(TEXTURE, "getMetadata", MethodType.methodType(Map.class));
        Class<?> CHECK_SERVER_RESPONSE = Class.forName("pro.gravit.launcher.core.api.features.UserFeatureAPI$CheckServerResponse", false, classloader);
        this.GETTER_GET_CHECK_SESSION_ID = lookup.findVirtual(CHECK_SERVER_RESPONSE, "sessionId", MethodType.methodType(String.class));
        this.GETTER_GET_CHECK_HARDWARE_ID = lookup.findVirtual(CHECK_SERVER_RESPONSE, "hardwareId", MethodType.methodType(String.class));
        this.GETTER_GET_CHECK_PROPERTIES = lookup.findVirtual(CHECK_SERVER_RESPONSE, "sessionProperties", MethodType.methodType(Map.class));
        this.GETTER_GET_CHECK_USER = lookup.findVirtual(CHECK_SERVER_RESPONSE, "user", MethodType.methodType(USER));
    }

    @Override
    public void selfTest() throws Throwable {
        Object api = this.GET_API_HOLDER.invoke();
        if (api == null) {
            throw new RuntimeException(String.format("Launcher API not initialized, classloader %s", this.API_HOLDER.getClassLoader().getClass().getName()));
        }
    }

    @Override
    public void error(Throwable e) {
        try {
            this.LOG_HELPER_ERROR.invoke(e);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void debug(String format, Object ... args) {
        try {
            this.LOG_HELPER_DEBUG.invoke(format, args);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<GenericGameProfile> findByUsername(String username) {
        try {
            Object api = this.GET_API_HOLDER.invoke();
            Object userFeature = this.GET_USER_FEATURE_API.invoke(api);
            CompletableFuture future = this.GET_USER_BY_USERNAME.invoke(userFeature, username);
            return future.thenApply(this::toGeneticGameProfile);
        }
        catch (Throwable e) {
            this.error(e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<GenericGameProfile> findByUUID(UUID uuid) {
        try {
            Object api = this.GET_API_HOLDER.invoke();
            Object userFeature = this.GET_USER_FEATURE_API.invoke(api);
            CompletableFuture future = this.GET_USER_BY_UUID.invoke(userFeature, uuid);
            return future.thenApply(this::toGeneticGameProfile);
        }
        catch (Throwable e) {
            this.error(e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<Boolean> joinServerAsync(String username, String accessToken, String serverId) {
        try {
            Object api = this.GET_API_HOLDER.invoke();
            Object userFeature = this.GET_USER_FEATURE_API.invoke(api);
            CompletableFuture future = this.JOIN_SERVER_BY_USERNAME.invoke(userFeature, username, accessToken, serverId);
            return future.thenApply(x -> true);
        }
        catch (Throwable e) {
            this.error(e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<Boolean> joinServerAsync(UUID uuid, String accessToken, String serverId) {
        try {
            Object api = this.GET_API_HOLDER.invoke();
            Object userFeature = this.GET_USER_FEATURE_API.invoke(api);
            CompletableFuture future = this.JOIN_SERVER_BY_UUID.invoke(userFeature, uuid, accessToken, serverId);
            return future.thenApply(x -> true);
        }
        catch (Throwable e) {
            this.error(e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<GenericGameProfile> checkServerAsync(String username, String serverID, String ip) {
        try {
            Object api = this.GET_API_HOLDER.invoke();
            Object userFeature = this.GET_USER_FEATURE_API.invoke(api);
            CompletableFuture future = this.CHECK_SERVER.invoke(userFeature, username, serverID, true);
            return future.thenApply(event -> {
                try {
                    HashMap<String, GenericProperty> properties = new HashMap<String, GenericProperty>();
                    LauncherAccessor.pushProperty(properties, LauncherUtils.SESSION_ID_PROPERTY, this.GETTER_GET_CHECK_SESSION_ID.invoke(event));
                    LauncherAccessor.pushProperty(properties, LauncherUtils.SESSION_HARDWARE_ID_PROPERTY, this.GETTER_GET_CHECK_HARDWARE_ID.invoke(event));
                    Map sessionProperties = this.GETTER_GET_CHECK_PROPERTIES.invoke(event);
                    if (sessionProperties != null) {
                        for (Map.Entry e : sessionProperties.entrySet()) {
                            LauncherAccessor.pushProperty(properties, LauncherUtils.SESSION_BASE_PROPERTY.concat((String)e.getKey()), (String)e.getValue());
                        }
                    }
                    Object user = this.GETTER_GET_CHECK_USER.invoke(event);
                    this.pushPlayerProfileProperties(properties, user);
                    String userUsername = this.GETTER_GET_USERNAME.invoke(user);
                    UUID userUUID = this.GETTER_GET_UUID.invoke(user);
                    return new GenericGameProfile(userUsername, userUUID, properties);
                }
                catch (Throwable e) {
                    this.error(e);
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Throwable e) {
            this.error(e);
            throw new RuntimeException(e);
        }
    }

    private GenericGameProfile toGeneticGameProfile(Object playerProfile) {
        try {
            HashMap<String, GenericProperty> properties = new HashMap<String, GenericProperty>();
            this.pushPlayerProfileProperties(properties, playerProfile);
            return new GenericGameProfile(this.GETTER_GET_USERNAME.invoke(playerProfile), this.GETTER_GET_UUID.invoke(playerProfile), properties);
        }
        catch (Throwable e) {
            this.error(e);
            throw new RuntimeException(e);
        }
    }

    void pushPlayerProfileProperties(Map<String, GenericProperty> properties, Object playerProfile) throws Throwable {
        Map profileProperties = this.GETTER_GET_PROPERTIES.invoke(playerProfile);
        if (profileProperties != null) {
            for (Map.Entry e : profileProperties.entrySet()) {
                LauncherAccessor.pushProperty(properties, (String)e.getKey(), (String)e.getValue());
            }
        }
        LauncherAccessor.pushProperty(properties, this.makeTexturesProperty(playerProfile));
    }

    public GenericProperty makeTexturesProperty(Object playerProfile) throws Throwable {
        Map textures = this.GETTER_GET_ASSETS.invoke(playerProfile);
        HashMap<String, LauncherUtils.GenericTexture> genericTextures = new HashMap<String, LauncherUtils.GenericTexture>();
        for (Map.Entry e : textures.entrySet()) {
            genericTextures.put((String)e.getKey(), this.toGenericTexture(e.getValue()));
        }
        LauncherUtils.MinecraftTexturesProperty property = new LauncherUtils.MinecraftTexturesProperty();
        property.timestamp = System.currentTimeMillis();
        property.profileId = this.GETTER_GET_UUID.invoke(playerProfile).toString().replace("-", "");
        property.profileName = this.GETTER_GET_USERNAME.invoke(playerProfile);
        property.isPublic = true;
        property.textures = genericTextures;
        String encoded = LauncherUtils.GSON.toJson((Object)property);
        String base64 = Base64.getEncoder().encodeToString(encoded.getBytes(StandardCharsets.UTF_8));
        return new GenericProperty("textures", base64, "");
    }

    private LauncherUtils.GenericTexture toGenericTexture(Object texture) throws Throwable {
        return new LauncherUtils.GenericTexture(this.GETTER_GET_TEXTURE_URL.invoke(texture), this.GETTER_GET_TEXTURE_HASH.invoke(texture), this.GETTER_GET_TEXTURE_METADATA.invoke(texture));
    }
}

