/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.launcher;

import com.mojang.authlib.launcher.GenericGameProfile;
import com.mojang.authlib.launcher.GenericProperty;
import com.mojang.authlib.launcher.LauncherAccessor;
import com.mojang.authlib.launcher.LauncherUtils;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import pro.gravit.launcher.base.request.RequestException;
import pro.gravit.launcher.core.api.LauncherAPIHolder;
import pro.gravit.launcher.core.api.model.Texture;
import pro.gravit.launcher.core.api.model.User;
import pro.gravit.utils.helper.LogHelper;

public class LauncherDefaultAccessor
implements LauncherAccessor {
    @Override
    public void selfTest() throws Throwable {
        if (LauncherAPIHolder.get() == null) {
            throw new RequestException("Launcher API not initialized");
        }
    }

    @Override
    public void error(Throwable e) {
        LogHelper.error((Throwable)e);
    }

    @Override
    public void debug(String format, Object ... args) {
        LogHelper.debug((String)format, (Object[])args);
    }

    @Override
    public CompletableFuture<GenericGameProfile> findByUsername(String username) {
        return LauncherAPIHolder.get().user().getUserByUsername(username).thenApply(this::toGeneticGameProfile);
    }

    @Override
    public CompletableFuture<GenericGameProfile> findByUUID(UUID uuid) {
        return LauncherAPIHolder.get().user().getUserByUUID(uuid).thenApply(this::toGeneticGameProfile);
    }

    @Override
    public CompletableFuture<Boolean> joinServerAsync(String username, String accessToken, String serverId) {
        return LauncherAPIHolder.get().user().joinServer(username, accessToken, serverId).thenApply(event -> true);
    }

    @Override
    public CompletableFuture<Boolean> joinServerAsync(UUID uuid, String accessToken, String serverId) {
        return LauncherAPIHolder.get().user().joinServer(uuid, accessToken, serverId).thenApply(event -> true);
    }

    @Override
    public CompletableFuture<GenericGameProfile> checkServerAsync(String username, String serverID, String ip) {
        return LauncherAPIHolder.get().user().checkServer(username, serverID, true).thenApply(event -> {
            HashMap<String, GenericProperty> properties = new HashMap<String, GenericProperty>();
            LauncherAccessor.pushProperty(properties, LauncherUtils.SESSION_ID_PROPERTY, event.sessionId());
            LauncherAccessor.pushProperty(properties, LauncherUtils.SESSION_HARDWARE_ID_PROPERTY, event.hardwareId());
            if (event.sessionProperties() != null) {
                for (Map.Entry e : event.sessionProperties().entrySet()) {
                    LauncherAccessor.pushProperty(properties, LauncherUtils.SESSION_BASE_PROPERTY.concat((String)e.getKey()), (String)e.getValue());
                }
            }
            LauncherDefaultAccessor.pushPlayerProfileProperties(properties, event.user());
            return new GenericGameProfile(event.user().getUsername(), event.user().getUUID(), properties);
        });
    }

    private GenericGameProfile toGeneticGameProfile(User playerProfile) {
        HashMap<String, GenericProperty> properties = new HashMap<String, GenericProperty>();
        LauncherDefaultAccessor.pushPlayerProfileProperties(properties, playerProfile);
        return new GenericGameProfile(playerProfile.getUsername(), playerProfile.getUUID(), properties);
    }

    public static GenericProperty makeTexturesProperty(User playerProfile) {
        Map textures = playerProfile.getAssets();
        HashMap<String, LauncherUtils.GenericTexture> genericTextures = new HashMap<String, LauncherUtils.GenericTexture>();
        for (Map.Entry e : textures.entrySet()) {
            genericTextures.put((String)e.getKey(), LauncherDefaultAccessor.toGenericTexture((Texture)e.getValue()));
        }
        LauncherUtils.MinecraftTexturesProperty property = new LauncherUtils.MinecraftTexturesProperty();
        property.timestamp = System.currentTimeMillis();
        property.profileId = playerProfile.getUUID().toString().replace("-", "");
        property.profileName = playerProfile.getUsername();
        property.isPublic = true;
        property.textures = genericTextures;
        String encoded = LauncherUtils.GSON.toJson((Object)property);
        String base64 = Base64.getEncoder().encodeToString(encoded.getBytes(StandardCharsets.UTF_8));
        return new GenericProperty("textures", base64, "");
    }

    private static LauncherUtils.GenericTexture toGenericTexture(Texture texture) {
        return new LauncherUtils.GenericTexture(texture.getUrl(), texture.getHash(), texture.getMetadata());
    }

    static void pushPlayerProfileProperties(Map<String, GenericProperty> properties, User playerProfile) {
        if (playerProfile.getProperties() != null) {
            for (Map.Entry e : playerProfile.getProperties().entrySet()) {
                LauncherAccessor.pushProperty(properties, (String)e.getKey(), (String)e.getValue());
            }
        }
        LauncherAccessor.pushProperty(properties, LauncherDefaultAccessor.makeTexturesProperty(playerProfile));
    }
}

