/*
 * Decompiled with CFR 0.152.
 */
package com.gravitlauncher.socketbridge.client;

import com.gravitlauncher.socketbridge.ErrorResponse;
import com.gravitlauncher.socketbridge.MessageHeader;
import com.gravitlauncher.socketbridge.Registry;
import com.gravitlauncher.socketbridge.client.AbstractClient;
import com.gravitlauncher.socketbridge.utils.IOUtils;
import com.gravitlauncher.socketbridge.utils.ThreadUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SocketClient
extends AbstractClient
implements AutoCloseable {
    private final ExecutorService sendExecutor;
    private final Thread readThread;
    private final Socket socket;

    public SocketClient(Registry registry, Registry registry2, Socket socket) {
        super(registry, registry2);
        this.sendExecutor = Executors.newSingleThreadExecutor(ThreadUtils.DAEMON_THREAD_FACTORY);
        this.readThread = ThreadUtils.DAEMON_THREAD_FACTORY.newThread(this::runReadThread);
        this.socket = socket;
        this.readThread.start();
    }

    public SocketClient(Registry registry, Registry registry2, SocketAddress socketAddress) {
        super(registry, registry2);
        this.socket = new Socket();
        this.socket.connect(socketAddress);
        this.sendExecutor = Executors.newSingleThreadExecutor(ThreadUtils.DAEMON_THREAD_FACTORY);
        this.readThread = ThreadUtils.DAEMON_THREAD_FACTORY.newThread(this::runReadThread);
        this.readThread.start();
    }

    @Override
    public boolean isAlive() {
        return !this.socket.isClosed();
    }

    @Override
    public CompletableFuture<MessageHeader> send(Object object, boolean bl, long l) {
        String string = this.registryRequest.get(object.getClass());
        if (string == null) {
            throw new RuntimeException(String.format("Object %s not registered", object.getClass().getName()));
        }
        CompletableFuture<MessageHeader> completableFuture = new CompletableFuture<MessageHeader>();
        this.sendExecutor.submit(() -> {
            byte[] byArray = this.gson.toJson(object).getBytes(StandardCharsets.UTF_8);
            MessageHeader messageHeader = new MessageHeader(string, bl, l, byArray.length);
            try {
                byte[] byArray2 = messageHeader.serialize();
                this.socket.getOutputStream().write(byArray2);
                this.socket.getOutputStream().write(byArray);
                this.socket.getOutputStream().flush();
                completableFuture.complete(messageHeader);
            }
            catch (Throwable throwable) {
                completableFuture.completeExceptionally(throwable);
            }
        });
        return completableFuture;
    }

    @Override
    public CompletableFuture<?> sendRequest(Object object) {
        CompletableFuture completableFuture = new CompletableFuture();
        this.send(object, false, this.counter.getAndIncrement()).handle((messageHeader, throwable) -> {
            if (throwable == null) {
                this.futureMap.put(messageHeader.requestId(), completableFuture);
            } else {
                completableFuture.completeExceptionally((Throwable)throwable);
            }
            return null;
        });
        return completableFuture;
    }

    private void runReadThread() {
        try {
            InputStream inputStream = this.socket.getInputStream();
            byte[] byArray = new byte[27];
            byte[] byArray2 = new byte[8192];
            while (!Thread.interrupted()) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                IOUtils.readNBytes(inputStream, byArray, 0, 27);
                int n = (int)MessageHeader.calculateSize(ByteBuffer.wrap(byArray));
                byteArrayOutputStream.write(byArray);
                if (byArray2.length < n) {
                    byArray2 = new byte[n];
                }
                IOUtils.readNBytes(inputStream, byArray2, 0, n);
                byteArrayOutputStream.write(byArray2, 0, n);
                byte[] byArray3 = byteArrayOutputStream.toByteArray();
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray3);
                MessageHeader messageHeader = MessageHeader.deserialize(byteBuffer);
                byteBuffer.get(byArray2, 0, (int)messageHeader.contentLength());
                Object var9_12 = null;
                Class clazz = this.registryResponse.get(messageHeader.name());
                if (clazz != null) {
                    try (InputStreamReader inputStreamReader = new InputStreamReader(new ByteArrayInputStream(byArray2, 0, (int)messageHeader.contentLength()));){
                        var9_12 = this.gson.fromJson((Reader)inputStreamReader, clazz);
                    }
                }
                this.onMessage(messageHeader, var9_12);
            }
        }
        catch (Throwable throwable) {
            for (CompletableFuture completableFuture : this.futureMap.values()) {
                completableFuture.completeExceptionally(throwable);
            }
        }
    }

    @Override
    protected void onMessage(MessageHeader messageHeader, Object object) {
        if (!messageHeader.isResponse()) {
            this.onEvent(messageHeader, object);
            return;
        }
        CompletableFuture completableFuture = (CompletableFuture)this.futureMap.get(messageHeader.requestId());
        if (object == null) {
            if (completableFuture != null) {
                completableFuture.completeExceptionally(new RuntimeException(String.format("Name '%s' not registered", messageHeader.name())));
            } else {
                this.onEvent(messageHeader, null);
            }
            return;
        }
        if (completableFuture != null) {
            if (object instanceof ErrorResponse) {
                ErrorResponse errorResponse = (ErrorResponse)object;
                completableFuture.completeExceptionally(new RuntimeException(errorResponse.error));
            } else {
                completableFuture.complete(object);
            }
        } else {
            this.onEvent(messageHeader, object);
        }
    }

    @Override
    protected void onEvent(MessageHeader messageHeader, Object object) {
    }

    @Override
    public void close() {
        if (this.readThread != null && this.readThread.isAlive()) {
            this.readThread.interrupt();
        }
        if (this.sendExecutor != null && !this.sendExecutor.isShutdown()) {
            this.sendExecutor.shutdownNow();
        }
        try {
            if (!this.socket.isClosed()) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

