/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.VersionHelpers;
import com.sun.jna.platform.win32.WinNT;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.windows.wmi.Win32Processor;
import oshi.hardware.CentralProcessor;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.util.platform.windows.WmiUtil;
import oshi.util.tuples.Triplet;

@ThreadSafe
public final class LogicalProcessorInformation {
    private static final boolean IS_WIN10_OR_GREATER = VersionHelpers.IsWindows10OrGreater();

    private LogicalProcessorInformation() {
    }

    public static Triplet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, List<CentralProcessor.ProcessorCache>> getLogicalProcessorInformationEx() {
        List<CentralProcessor.PhysicalProcessor> list;
        Object object;
        WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX[] sYSTEM_LOGICAL_PROCESSOR_INFORMATION_EXArray = Kernel32Util.getLogicalProcessorInformationEx(65535);
        ArrayList<WinNT.GROUP_AFFINITY[]> arrayList = new ArrayList<WinNT.GROUP_AFFINITY[]>();
        HashSet<CentralProcessor.ProcessorCache> hashSet = new HashSet<CentralProcessor.ProcessorCache>();
        ArrayList<WinNT.GROUP_AFFINITY> arrayList2 = new ArrayList<WinNT.GROUP_AFFINITY>();
        ArrayList<WinNT.NUMA_NODE_RELATIONSHIP> arrayList3 = new ArrayList<WinNT.NUMA_NODE_RELATIONSHIP>();
        HashMap<WinNT.GROUP_AFFINITY, Integer> hashMap = new HashMap<WinNT.GROUP_AFFINITY, Integer>();
        block6: for (WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX object22 : sYSTEM_LOGICAL_PROCESSOR_INFORMATION_EXArray) {
            switch (object22.relationship) {
                case 3: {
                    arrayList.add(((WinNT.PROCESSOR_RELATIONSHIP)object22).groupMask);
                    continue block6;
                }
                case 2: {
                    object = (WinNT.CACHE_RELATIONSHIP)object22;
                    hashSet.add(new CentralProcessor.ProcessorCache(((WinNT.CACHE_RELATIONSHIP)object).level, ((WinNT.CACHE_RELATIONSHIP)object).associativity, ((WinNT.CACHE_RELATIONSHIP)object).lineSize, ((WinNT.CACHE_RELATIONSHIP)object).cacheSize, CentralProcessor.ProcessorCache.Type.values()[((WinNT.CACHE_RELATIONSHIP)object).type]));
                    continue block6;
                }
                case 0: {
                    list = (WinNT.PROCESSOR_RELATIONSHIP)object22;
                    arrayList2.add(((WinNT.PROCESSOR_RELATIONSHIP)((Object)list)).groupMask[0]);
                    if (!IS_WIN10_OR_GREATER) continue block6;
                    hashMap.put(((WinNT.PROCESSOR_RELATIONSHIP)((Object)list)).groupMask[0], Integer.valueOf(((WinNT.PROCESSOR_RELATIONSHIP)((Object)list)).efficiencyClass));
                    continue block6;
                }
                case 1: {
                    arrayList3.add((WinNT.NUMA_NODE_RELATIONSHIP)object22);
                    continue block6;
                }
            }
        }
        arrayList2.sort(Comparator.comparing(gROUP_AFFINITY -> (long)gROUP_AFFINITY.group * 64L + (long)Long.numberOfTrailingZeros(gROUP_AFFINITY.mask.longValue())));
        arrayList.sort(Comparator.comparing(gROUP_AFFINITYArray -> (long)gROUP_AFFINITYArray[0].group * 64L + (long)Long.numberOfTrailingZeros(gROUP_AFFINITYArray[0].mask.longValue())));
        arrayList3.sort(Comparator.comparing(nUMA_NODE_RELATIONSHIP -> nUMA_NODE_RELATIONSHIP.nodeNumber));
        HashMap hashMap2 = new HashMap();
        WbemcliUtil.WmiResult<Win32Processor.ProcessorIdProperty> wmiResult = Win32Processor.queryProcessorId();
        for (int i = 0; i < wmiResult.getResultCount(); ++i) {
            hashMap2.put(i, WmiUtil.getString(wmiResult, Win32Processor.ProcessorIdProperty.PROCESSORID, i));
        }
        ArrayList<CentralProcessor.LogicalProcessor> arrayList4 = new ArrayList<CentralProcessor.LogicalProcessor>();
        HashMap<Integer, Integer> hashMap3 = new HashMap<Integer, Integer>();
        object = new HashMap();
        for (WinNT.NUMA_NODE_RELATIONSHIP nUMA_NODE_RELATIONSHIP2 : arrayList3) {
            int n = nUMA_NODE_RELATIONSHIP2.nodeNumber;
            short s = nUMA_NODE_RELATIONSHIP2.groupMask.group;
            long l = nUMA_NODE_RELATIONSHIP2.groupMask.mask.longValue();
            int n2 = Long.numberOfTrailingZeros(l);
            int n3 = 63 - Long.numberOfLeadingZeros(l);
            for (int i = n2; i <= n3; ++i) {
                if ((l & 1L << i) == 0L) continue;
                int n4 = LogicalProcessorInformation.getMatchingCore(arrayList2, s, i);
                int n5 = LogicalProcessorInformation.getMatchingPackage(arrayList, s, i);
                hashMap3.put(n4, n5);
                object.put(n4, hashMap2.getOrDefault(n5, ""));
                CentralProcessor.LogicalProcessor logicalProcessor = new CentralProcessor.LogicalProcessor(i, n4, n5, n, s);
                arrayList4.add(logicalProcessor);
            }
        }
        list = LogicalProcessorInformation.getPhysProcs(arrayList2, hashMap, hashMap3, (Map<Integer, String>)object);
        return new Triplet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, List<CentralProcessor.ProcessorCache>>(arrayList4, list, AbstractCentralProcessor.orderedProcCaches(hashSet));
    }

    private static List<CentralProcessor.PhysicalProcessor> getPhysProcs(List<WinNT.GROUP_AFFINITY> list, Map<WinNT.GROUP_AFFINITY, Integer> map, Map<Integer, Integer> map2, Map<Integer, String> map3) {
        ArrayList<CentralProcessor.PhysicalProcessor> arrayList = new ArrayList<CentralProcessor.PhysicalProcessor>();
        for (int i = 0; i < list.size(); ++i) {
            int n = map.getOrDefault(list.get(i), 0);
            String string = map3.getOrDefault(i, "");
            int n2 = map2.getOrDefault(i, 0);
            arrayList.add(new CentralProcessor.PhysicalProcessor(n2, i, n, string));
        }
        return arrayList;
    }

    private static int getMatchingPackage(List<WinNT.GROUP_AFFINITY[]> list, int n, int n2) {
        for (int i = 0; i < list.size(); ++i) {
            for (int j = 0; j < list.get(i).length; ++j) {
                if ((list.get((int)i)[j].mask.longValue() & 1L << n2) == 0L || list.get((int)i)[j].group != n) continue;
                return i;
            }
        }
        return 0;
    }

    private static int getMatchingCore(List<WinNT.GROUP_AFFINITY> list, int n, int n2) {
        for (int i = 0; i < list.size(); ++i) {
            if ((list.get((int)i).mask.longValue() & 1L << n2) == 0L || list.get((int)i).group != n) continue;
            return i;
        }
        return 0;
    }

    public static Triplet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, List<CentralProcessor.ProcessorCache>> getLogicalProcessorInformation() {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION[] sYSTEM_LOGICAL_PROCESSOR_INFORMATIONArray = Kernel32Util.getLogicalProcessorInformation();
        for (WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION sYSTEM_LOGICAL_PROCESSOR_INFORMATION : sYSTEM_LOGICAL_PROCESSOR_INFORMATIONArray) {
            if (sYSTEM_LOGICAL_PROCESSOR_INFORMATION.relationship == 3) {
                arrayList.add(sYSTEM_LOGICAL_PROCESSOR_INFORMATION.processorMask.longValue());
                continue;
            }
            if (sYSTEM_LOGICAL_PROCESSOR_INFORMATION.relationship != 0) continue;
            arrayList2.add(sYSTEM_LOGICAL_PROCESSOR_INFORMATION.processorMask.longValue());
        }
        arrayList2.sort(null);
        arrayList.sort(null);
        ArrayList arrayList3 = new ArrayList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            long l = (Long)arrayList2.get(i);
            int n = Long.numberOfTrailingZeros(l);
            int n2 = 63 - Long.numberOfLeadingZeros(l);
            for (int j = n; j <= n2; ++j) {
                if ((l & 1L << j) == 0L) continue;
                CentralProcessor.LogicalProcessor logicalProcessor = new CentralProcessor.LogicalProcessor(j, i, LogicalProcessorInformation.getBitMatchingPackageNumber(arrayList, j));
                arrayList3.add(logicalProcessor);
            }
        }
        return new Triplet<WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION[], Object, Object>((WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION[])arrayList3, null, null);
    }

    private static int getBitMatchingPackageNumber(List<Long> list, int n) {
        for (int i = 0; i < list.size(); ++i) {
            if ((list.get(i) & 1L << n) == 0L) continue;
            return i;
        }
        return 0;
    }
}

